﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Implements ISaveFileDialogCompleted

    Private appService As PhoneApplicationService = PhoneApplicationService.Current
    Private photoChooser As New PhotoChooserTask()
    Private writeableBitmap As WriteableBitmap
    Private jpegBits() As Byte
    Private pixels() As Integer


    Public Sub New()
        InitializeComponent()

        appbarLoadButton = TryCast(Me.ApplicationBar.Buttons(0), 
            ApplicationBarIconButton)
        appbarSetBitsButton = TryCast(Me.ApplicationBar.Buttons(1), 
            ApplicationBarIconButton)
        appbarSaveButton = TryCast(Me.ApplicationBar.Buttons(2), 
            ApplicationBarIconButton)

        AddHandler photoChooser.Completed, AddressOf OnPhotoChooserCompleted
    End Sub


    Private Sub OnAppbarLoadClick(ByVal sender As Object, ByVal args As EventArgs)
        bitSelectDialog.Visibility = Visibility.Collapsed
        appbarSetBitsButton.IsEnabled = False
        appbarSaveButton.IsEnabled = False

        photoChooser.Show()
    End Sub


    Private Sub OnPhotoChooserCompleted(ByVal sender As Object, ByVal args As PhotoResult)
        If args.Error Is Nothing AndAlso args.ChosenPhoto IsNot Nothing Then
            jpegBits = New Byte(args.ChosenPhoto.Length - 1) {}
            args.ChosenPhoto.Read(jpegBits, 0, jpegBits.Length)
            LoadBitmap(jpegBits)
        End If
    End Sub


    Private Sub LoadBitmap(ByVal jpegBits() As Byte)
        ' Create WriteableBitmap from JPEG bits
        Dim memoryStream As New MemoryStream(jpegBits)
        Dim bitmapImage As New BitmapImage()
        bitmapImage.SetSource(memoryStream)
        writeableBitmap = New WriteableBitmap(bitmapImage)
        img.Source = writeableBitmap

        ' Copy pixels into field array
        pixels = New Integer(writeableBitmap.PixelWidth * writeableBitmap.PixelHeight - 1) {}

        For i = 0 To pixels.Length - 1
            pixels(i) = writeableBitmap.Pixels(i)
        Next i

        appbarSetBitsButton.IsEnabled = True
        appbarSaveButton.IsEnabled = True
        ApplyBitSettingsToBitmap()
    End Sub


    Private Sub OnAppbarSetBitsClick(ByVal sender As Object, ByVal args As EventArgs)
        bitSelectDialog.Visibility = If(bitSelectDialog.Visibility = Visibility.Collapsed,
                                        Visibility.Visible, Visibility.Collapsed)
    End Sub


    Private Sub OnBitSelectDialogColorBitsChanged(ByVal sender As Object,
                                                  ByVal args As EventArgs)
        ApplyBitSettingsToBitmap()
    End Sub


    Private Sub ApplyBitSettingsToBitmap()
        If pixels Is Nothing OrElse writeableBitmap Is Nothing Then Return

        Dim mask = -16777216 ' ie, FF000000

        For clr = 0 To 2
            mask = mask Or (((&HFF << (8 - bitSelectDialog.ColorBits(clr))) And &HFF) << (16 - 8 * clr))
        Next clr

        For i = 0 To pixels.Length - 1
            writeableBitmap.Pixels(i) = mask And pixels(i)
        Next i

        writeableBitmap.Invalidate()
    End Sub


    Private Sub OnAppbarSaveClick(ByVal sender As Object, ByVal args As EventArgs)
        Dim fileNameNumber = 0
        Dim mediaLib As New MediaLibrary()
        Dim savedPictures = mediaLib.SavedPictures

        For Each picture In savedPictures
            Dim filename = System.IO.Path.GetFileNameWithoutExtension(picture.Name)
            Dim num As Integer

            If filename.StartsWith("Posterizer") Then
                If Int32.TryParse(filename.Substring(10), num) Then
                    fileNameNumber = Math.Max(fileNameNumber, num)
                End If
            End If
        Next picture

        Dim saveFileName = String.Format("Posterizer{0:D3}", fileNameNumber + 1)

        Dim uri = "/Petzold.Phone.Silverlight;component/SaveFileDialog.xaml" &
            "?FileName=" & saveFileName

        Me.NavigationService.Navigate(New Uri(uri, UriKind.Relative))

    End Sub


    Public Sub SaveFileDialogCompleted(ByVal okPressed As Boolean,
                                       ByVal filename As String) Implements Petzold.Phone.Silverlight.ISaveFileDialogCompleted.SaveFileDialogCompleted
        If okPressed Then
            Dim memoryStream As New MemoryStream()
            writeableBitmap.SaveJpeg(memoryStream,
                                     writeableBitmap.PixelWidth,
                                     writeableBitmap.PixelHeight, 0, 75)
            memoryStream.Position = 0

            Dim mediaLib As New MediaLibrary()
            mediaLib.SavePicture(filename, memoryStream)
        End If
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        appService.State("colorBits") = bitSelectDialog.ColorBits

        If jpegBits IsNot Nothing Then
            appService.State("jpegBits") = jpegBits
        End If

        If TypeOf args.Content Is SaveFileDialog Then
            Dim page = TryCast(args.Content, SaveFileDialog)
            page.SetTitle(ApplicationTitle.Text)
        End If

        MyBase.OnNavigatedFrom(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        If Me.NavigationContext.QueryString.ContainsKey("token") Then
            Dim token = Me.NavigationContext.QueryString("token")

            Dim mediaLib As New MediaLibrary()
            Dim picture = mediaLib.GetPictureFromToken(token)
            Dim stream = picture.GetImage()
            jpegBits = New Byte(stream.Length - 1) {}
            stream.Read(jpegBits, 0, jpegBits.Length)
            LoadBitmap(jpegBits)
        ElseIf appService.State.ContainsKey("colorBits") Then
            Dim colorBits() = CType(appService.State("colorBits"), Integer())
            bitSelectDialog.Initialize(colorBits)
        End If

        If appService.State.ContainsKey("jpegBits") Then
            jpegBits = CType(appService.State("jpegBits"), Byte())
            LoadBitmap(jpegBits)
        End If
        MyBase.OnNavigatedTo(args)
    End Sub
End Class